﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Configuration;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.TBI;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

/// <summary>
/// Summary description for Helpers
/// </summary>
public static class Helpers
{
    public static Boolean isInteger(string valueToCheck)
    {
        return BusinessHelper.isInteger(valueToCheck);
    }

    public static Boolean isString(string valueToCheck)
    {
        return BusinessHelper.isString(valueToCheck);
    }

    public static string GetConfigEntry(string key)
    {
        return BusinessHelper.GetConfigEntry(key);
    }

    public static string GetDBConfigEntry(string configValue)
    {

        //Performance Enhancement

        string key = "GetDBConfigEntry_" + configValue;
        int tbiCode = 2;
        string setting = "";

        if (!CacheHelper.Get(key, out setting))
        {
            setting = "";
            var vSetting = VeteransAffairs.Registries.Business.Utilities.SqlProvider.ExecuteScalar("RegistryConnectionString", "CRS_SP_RETRIEVE_SETTING", new object[] { configValue, tbiCode });

            if (vSetting != null)
            {
                setting = vSetting.ToString();

                CacheHelper.Add(setting, key);
            }
        }

        return setting;
        //return BusinessHelper.GetDBConfigEntry(key);
    }

    /// <summary>
    /// getCurrentServiceToUse: pulls from settings.  If null, returns MDWS, else returns either MDWS or VIA
    /// </summary>
    /// <returns></returns>
    public static string getCurrentServiceToUse()
    {
        return BusinessHelper.getCurrentServiceToUse("TBIServiceToUse");
    }

    public static int getIntFromString(string inString)
    {
        return BusinessHelper.getIntFromString(inString);
    }

    public static bool IsSessionVariableNullOrEmpty(object sessionVariable)
    {
        return BusinessHelper.IsSessionVariableNullOrEmpty(sessionVariable);
    }

    public static string GetStringFromSessionVariable(object sessionVariable)
    {
        return BusinessHelper.GetStringFromSessionVariable(sessionVariable);
    }

    public static int? getNullableIntFromString(string inString)
    {
        return BusinessHelper.getNullableIntFromString(inString);
    }

    public static string getStringFromNullableInt(int? inInt)
    {
        return BusinessHelper.getStringFromNullableInt(inInt);
    }

    public static DateTime? getNullableDateFromString(string inString)
    {
        return BusinessHelper.getNullableDateFromString(inString);
    }

    public static Char? getNullableCharFromString(string inString)
    {
        return BusinessHelper.getNullableCharFromString(inString);
    }

    public static string getShortDateStringFromNullableDate(DateTime? inDate)
    {
        return BusinessHelper.getShortDateStringFromNullableDate(inDate);
    }
    
    public static Exception HandleTBIException(Exception exception, string screenName, string eventId, string functionname)
    {
        WriteLogToFile(exception, screenName, eventId, functionname);
        return exception;
    }

    private static void WriteLogToFile(Exception ex, string _screenName, string _eventId, string _functionname)
    {
        string path = GetLogLocation();
        string flatmessage = "TBI INSTRUMENT ERROR:: " + " :::SCREENNAME= " + _screenName + ":::Function=" + _functionname;
        
        if (ex != null)
        {
            flatmessage += " ::: EXCEPTION= " + ex.ToString();            
        }              
        Logging.WriteLogToFile(flatmessage, true);    
    } 

    private static string GetLogLocation()
    {
        return ConfigurationManager.AppSettings["LogsPath"].ToString() + @"\" + DateTime.Today.Year + @"\" + DateTime.Today.Month + @"\" + DateTime.Today.Day + ".log";
    }

    public static TBIServiceTO BuildTBIServiceTO(string _inSiteCode, string _inDUZ, string _inDFN, string _inServerIP, string _inServerPort, int _inTBIEvaluationNoteId, int _inTBIFollowUpNoteId)
    {
        TBIServiceTO result = new TBIServiceTO();
        result.siteCode = _inSiteCode;
        result.DUZ = _inDUZ;
        result.DFN = _inDFN;
        result.CprsSentTBIEvaluationNoteId = _inTBIEvaluationNoteId;
        result.CprsSentTBIFollowUpNoteId = _inTBIFollowUpNoteId;
        result.ServerIP = _inServerIP;
        result.ServerPort = _inServerPort;
        return result;
    }

    public static void ExtractCPRSVariables(Page page, out string _inSiteCode, out string _inDUZ, out string _inDFN, out string _inServerIP, out string _inServerPort, out int _inTBIEvaluationNoteId, out int _inTBIFollowUpNoteId)
    {
        ExtractCPRSVariables(page.Session, page.Response, out _inSiteCode, out _inDUZ, out _inDFN, out _inServerIP, out _inServerPort, out _inTBIEvaluationNoteId, out _inTBIFollowUpNoteId);
    }

    public static void ExtractCPRSVariables(System.Web.SessionState.HttpSessionState session, HttpResponse response, out string _inSiteCode, out string _inDUZ, out string _inDFN, out string _inServerIP, out string _inServerPort, out int _inTBIEvaluationNoteId, out int _inTBIFollowUpNoteId)
    {
        _inSiteCode = BusinessHelper.GetStringFromSessionVariable(session["SiteCode"]);
        _inDUZ = BusinessHelper.GetStringFromSessionVariable(session["DUZ"]);
        _inDFN = BusinessHelper.GetStringFromSessionVariable(session["DFN"]);
        _inServerIP = BusinessHelper.GetStringFromSessionVariable(session["ServerIP"]);
        _inServerPort = BusinessHelper.GetStringFromSessionVariable(session["ServerPort"]);

        int.TryParse(BusinessHelper.GetStringFromSessionVariable(session["TBIEvaluationNoteId"]), out _inTBIEvaluationNoteId);
        int.TryParse(BusinessHelper.GetStringFromSessionVariable(session["TBIFollowUpNoteId"]), out _inTBIFollowUpNoteId);

        if (string.IsNullOrEmpty(_inDUZ)
            || string.IsNullOrEmpty(_inDFN)
            || string.IsNullOrEmpty(_inSiteCode)
            || string.IsNullOrEmpty(_inServerIP)
            || string.IsNullOrEmpty(_inServerPort))
        {
            string sError = "PatientInstrumentsMain.Page_Load(): WarningRedirect: null or missing query string values: ";
            if (BusinessHelper.IsSessionVariableNullOrEmpty(session["DUZ"]))
                sError += "DUZ;";
            if (BusinessHelper.IsSessionVariableNullOrEmpty(session["DFN"]))
                sError += "DFN;";
            if (BusinessHelper.IsSessionVariableNullOrEmpty(session["SiteCode"]))
                sError += "SiteCode;";
            if (BusinessHelper.IsSessionVariableNullOrEmpty(session["ServerIP"]))
                sError += "ServerIP";
            if (BusinessHelper.IsSessionVariableNullOrEmpty(session["ServerPort"]))
                sError += "ServerPort";

            Logging.WriteLogToFile("PatientInstruments.Page_Load(): WarningRedirect: " + sError);
            //if any value is not passed in then the page was called incorrectly, display error message to user
            response.Redirect("Warning.aspx?err=7", false);
        }
    }

    #region TBI Instruments

    //Shared method to save radio buttons. Before using this make sure the code being replaced is EXACTLY the same.
    public static void SaveSingleSelect(SURVEY survey, RadioButtonList radioButtonList, string questionNumber)
    {
        if (radioButtonList.SelectedIndex > -1)
        {
            List<STD_QUESTION_CHOICE> availableChoices = VeteransAffairs.Registries.QuestionChoiceRetriever.GetQuestionChoices(questionNumber);
            SURVEY_RESULT currentResult = survey.SURVEY_RESULTs.FirstOrDefault(item => availableChoices.FirstOrDefault(choice => choice.STD_QUESTION_CHOICE_ID == item.STD_QUESTION_CHOICE_ID) != null);
            int selectedValue = Convert.ToInt32(radioButtonList.SelectedValue);
            if (null != currentResult)
            {
                if (currentResult.STD_QUESTION_CHOICE_ID != selectedValue)
                {
                    currentResult.SetAsUpdateOnSubmit();
                    currentResult.STD_QUESTION_CHOICE_ID = selectedValue;
                }
                else
                {
                    currentResult.SetAsNoChangeOnSubmit();
                }
            }
            else
            {
                SURVEY_RESULT result = new SURVEY_RESULT();
                survey.SURVEY_RESULTs.Add(result);
                result.STD_QUESTION_CHOICE_ID = selectedValue;
            }
        }
    }

    public static int[] GetSelectedIndexes(CheckBoxList chkList)
    {
        List<int> selectedIndexes = new List<int>();
        foreach (ListItem item in chkList.Items)
        {
            if (item.Selected)
            {
                selectedIndexes.Add(chkList.Items.IndexOf(item));
            }
        }
        return selectedIndexes.ToArray();
    }

    public static bool SetupPageFromCache(Page page, string cacheName)
    {
        Dictionary<string, string> cache;
        return SetupPageFromCache(page, cacheName, out cache);
    }

    public static bool SetupPageFromCache(Page page, string cacheName, out Dictionary<string, string> cache)
    {
        cache = page.Session[cacheName] as Dictionary<string, string>;
        if (null == cache)
            return false;
        SetupControlFromCache(page, cache);
        return true;
    }

    private static void SetupControlFromCache(Control control, Dictionary<string, string> cache)
    {
        if (null == control)
            return;

        string key = control.ID;
        string value = string.Empty;

        try
        {
            if (null != key)
            {
                if (cache.TryGetValue(key, out value))
                {
                    if (!string.IsNullOrEmpty(value))
                    {
                        if (control is TextBox)
                        {
                            TextBox txt = control as TextBox;
                            if (txt != null)
                                txt.Text = value;
                        }
                        else if (control is CheckBox)
                        {
                            CheckBox chk = control as CheckBox;
                            if (chk != null)
                                chk.Checked = bool.Parse(value);
                        }
                        else if (control is CheckBoxList)
                        {
                            CheckBoxList cbl = control as CheckBoxList;
                            if (cbl != null)
                            {
                                string[] indexes = value.Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
                                if (null != indexes && null != cbl.Items)
                                {
                                    for (int i = 0; i < cbl.Items.Count; i++)
                                    {
                                        cbl.Items[i].Selected = indexes.Contains(i.ToString());
                                    }
                                }
                            }
                        }
                        else if (control is DropDownList)
                        {
                            DropDownList ddl = control as DropDownList;
                            if (ddl != null)
                            {
                                ddl.SelectedIndex = int.Parse(value);
                            }
                        }
                        else if (control is RadioButtonList)
                        {
                            RadioButtonList rbl = control as RadioButtonList;
                            if (rbl != null)
                                rbl.SelectedIndex = int.Parse(value);
                        }
                    }
                }
            }
        }
        catch (Exception x)
        {
            Logging.WriteLogToFile(string.Format("Error: key={0}, value={1}\r\n", key, value) + x.ToString());
        }
        if (!(control is Repeater))
        {
            foreach (Control child in control.Controls)
                SetupControlFromCache(child, cache);
        }
    }

    public static Dictionary<string, string> SavePageToCache(Page page, string cacheName)
    {
        Dictionary<string, string> cache = new Dictionary<string, string>();
        CacheControlValue(page, cache);
        page.Session[cacheName] = cache;
        return cache;
    }

    private static void CacheControlValue(Control control, Dictionary<string, string> cache)
    {
        if (null == control)
            return;
        if (control is TextBox)
        {
            TextBox txt = control as TextBox;
            if (txt != null)
                cache[control.ID] = txt.Text;
        }
        else if (control is CheckBoxList)
        {
            CheckBoxList cbl = control as CheckBoxList;
            if (cbl != null)
                cache[control.ID] = string.Join(",", Helpers.GetSelectedIndexes(cbl).Select(i => i.ToString()).ToArray());
        }
        else if (control is RadioButtonList)
        {
            RadioButtonList rbl = control as RadioButtonList;
            if (rbl != null)
                cache[control.ID] = rbl.SelectedIndex.ToString();
        }
        else if (control is DropDownList)
        {
            DropDownList ddl = control as DropDownList;
            if (ddl != null)
                cache[control.ID] = ddl.SelectedIndex.ToString();
        }
        else if (control is CheckBox)
        {
            CheckBox chk = control as CheckBox;
            if (chk != null)
                cache[control.ID] = chk.Checked.ToString();
        }
        if (!(control is Repeater))
        {
            foreach (Control child in control.Controls)
                CacheControlValue(child, cache);
        }
    }
    #endregion TBI Instruments
}
